package com.ejie.p06b.dao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Locale;

import com.ejie.p06b.datatype.model.P06B60T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.general.P06BTablas;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BFecha;
import com.ejie.p06b.util.bd.P06BServidorConexionesBD;

/**
 * XXXX
 * Inserte aqu� la descripci�n del tipo.
 * Fecha de creaci�n: (09/05/07)
 */
public class P06B60T00DAO {

	static private P06B60T00DAO instance = null;

	public static P06B60T00DAO getInstance() {
	     if (instance == null) {
	          synchronized (P06B60T00DAO.class) {
	          		if (instance == null) {
	                     instance = new P06B60T00DAO();
	                }
	          }
	     }
	     return instance;
	}

	/**
    * Inserta un registro de la BD
    * @param obj.
    *            objeto a insertar
    * @return String -> El numero de expediente generado
    * @throws SQLException
    */
	public void insert(P06B60T00Datatype obj) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B60T00DAO-insert");

		PreparedStatement lstm  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        //Antes calculo el expediente siguiente a asignar
        String sql = INSERT_COMPLETA;
        lstm = lconConexion.prepareStatement(sql);

    	lstm.setString(1,obj.getnExpediente());
    	lstm.setByte(2,obj.getcFDeclaro());
//    	Integer.parseInt(obj.getcFImpFondos().replaceAll(".", ""));
    	String sUpdateNum = "";
    	if (obj.getcFImpFondos()==null){
    		sUpdateNum = null;
    	}else if ("".equals(obj.getcFImpFondos().trim())){
    		sUpdateNum = null;
    	}else{
    		sUpdateNum = obj.getcFImpFondos().replaceAll("\\.", "");
    	}
    	lstm.setString(3,sUpdateNum);
    	sUpdateNum = "";
    	if (obj.getcFImpCapacidad()==null){
    		sUpdateNum = null;
    	}else if ("".equals(obj.getcFImpCapacidad().trim())){
    		sUpdateNum = null;
    	}else{
    		sUpdateNum = obj.getcFImpCapacidad().replaceAll("\\.", "");
    	}
    	lstm.setString(4,sUpdateNum);
    	lstm.setBoolean(5,obj.iscFContrataSeguro());
    	lstm.setString(6,obj.getcFTextoSeguro());
    	lstm.setBoolean(7,obj.iscFContrataAval());
    	lstm.setString(8,obj.getcFTextoAval());

    	lstm.executeUpdate();
    	//Cierro recursos
    	if(lstm!=null) lstm.close();
    	if(lconConexion!=null) lconConexion.close();
        P06BLog.send(2,this, "Fin P06B60T00DAO-insert");
        return;
	}

	/**
    * Modifica un registro de la BD
    * @param obj.
    *            objeto a modificar
    * @return String -> El numero de expediente modificado
    * @throws SQLException
    */
	public void update(P06B60T00Datatype obj) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B60T00DAO-update");

		PreparedStatement lstm  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = UPDATE_COMPLETA;
        lstm = lconConexion.prepareStatement(sql);

    	lstm.setInt(1,obj.getcFDeclaro());
    	String sUpdateNum = "";
    	if (obj.getcFImpFondos()==null){
    		sUpdateNum = null;
    	}else if ("".equals(obj.getcFImpFondos().trim())){
    		sUpdateNum = null;
    	}else{
    		sUpdateNum = obj.getcFImpFondos().replaceAll("\\.", "");
    	}
    	lstm.setString(2,sUpdateNum);
    	sUpdateNum = "";
    	if (obj.getcFImpCapacidad()==null){
    		sUpdateNum = null;
    	}else if ("".equals(obj.getcFImpCapacidad().trim())){
    		sUpdateNum = null;
    	}else{
    		sUpdateNum = obj.getcFImpCapacidad().replaceAll("\\.", "");
    	}
    	lstm.setString(3,sUpdateNum);
    	lstm.setBoolean(4,obj.iscFContrataSeguro());
    	lstm.setString(5,obj.getcFTextoSeguro());
    	lstm.setBoolean(6,obj.iscFContrataAval());
    	lstm.setString(7,obj.getcFTextoAval());
    	lstm.setString(8,obj.getnExpediente());
    	lstm.executeUpdate();
    	//Cierro recursos
        if(lstm!=null) lstm.close();
        if(lconConexion!=null)lconConexion.close();
        P06BLog.send(2,this, "Fin P06B60T00DAO-update");
//      return obj.getnExpediente().toUpperCase();
        return;
	}

	/**
    * Borra un registro de la BD
    * @param obj.
    *            objeto a modificar
    * @return String -> El numero de expediente modificado
    * @throws SQLException
    */
	public void delete(String expediente) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B60T00DAO-delete");

		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        String sql = DELETE_COMPLETA;
        lstm = lconConexion.prepareStatement(sql);

    	lstm.setString(1,expediente);
    	lstm.executeUpdate();
    	//Cierro recursos
		if(lrst!=null)
			lrst.close();
    	if(lstm!=null)
    		lstm.close();
    	if(lconConexion!=null)
    		lconConexion.close();
        P06BLog.send(2,this, "Fin P06B60T00DAO-delete");
        return;
	}

	/**
    * Obtiene un registro de la BD a partir del c�digo
    * @param codigoPK.
    *            clave primaria
    * @return un objeto P06B60T00Datatype o null si no se encuentra
    * nada.
	 * @throws Exception
    */
	public P06B60T00Datatype select(String codigoPK) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B60T00Datatype-select");
		P06B60T00Datatype result = new P06B60T00Datatype();
    	result.setnExpediente(codigoPK.toUpperCase());
		result.setcFDeclaro(P06BConstantes.P06B_CF_NODEFINIDA);
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,codigoPK.toUpperCase());
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	result = new P06B60T00Datatype();
				result.setcFDeclaro(lrst.getByte(P06BTablas.P06B_P06B60_CF_DECLARO));
				result.setcFImpFondos(lrst.getString(P06BTablas.P06B_P06B60_CF_IMPFONDOS)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_IMPFONDOS));
				result.setcFImpCapacidad(lrst.getString(P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD));
				result.setcFContrataSeguro(lrst.getBoolean(P06BTablas.P06B_P06B60_CF_CONTRATASEGURO));
				result.setcFTextoSeguro(lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOSEGURO)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOSEGURO));
				result.setcFContrataAval(lrst.getBoolean(P06BTablas.P06B_P06B60_CF_CONTRATAAVAL));
				result.setcFTextoAval(lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOAVAL)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOAVAL));
	        }
	        P06BLog.send(2,this, "Fin P06B60T00Datatype-select");
        }
        finally{
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
        }
		return result;
	}


	/**
    * Obtiene un registro de la BD a partir del c�digo
    * @param codigoPK.
    *            clave primaria
    * @return un objeto P06B60T00Datatype o null si no se encuentra
    * nada.
	 * @throws Exception
    */
	public P06B60T00Datatype selectIncorporacionOld(String expediente, int nEjerIncorporarDEC) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B60T00DAO-selectIncorporacion");
		P06B60T00Datatype obj60 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK_INCORPORACION;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nEjerIncorporarDEC);
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	obj60 = new P06B60T00Datatype();

	        	//Mover campos 60
		    	obj60.setnExpediente(expediente.toUpperCase());
		    	obj60.setcFDeclaro(lrst.getByte(P06BTablas.P06B_P06B60_CF_DECLARO));
		    	obj60.setcFImpFondos(lrst.getString(P06BTablas.P06B_P06B60_CF_IMPFONDOS)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_IMPFONDOS));
		    	obj60.setcFImpCapacidad(lrst.getString(P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD));
		    	obj60.setcFContrataSeguro(lrst.getBoolean(P06BTablas.P06B_P06B60_CF_CONTRATASEGURO));
		    	obj60.setcFTextoSeguro(lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOSEGURO)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOSEGURO));
		    	obj60.setcFContrataAval(lrst.getBoolean(P06BTablas.P06B_P06B60_CF_CONTRATAAVAL));
		    	obj60.setcFTextoAval(lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOAVAL)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOAVAL));

	        	//Mover campos 32
		    	obj60.setcFDeclaro(lrst.getByte(P06BTablas.P06B_P06B32_TIPO_CAPAC_FINAN));
				if (lrst.getBoolean(P06BTablas.P06B_P06B32_IMPORTEAVAL)==false){
			    	obj60.setcFContrataAval(false);
				}else{
			    	obj60.setcFContrataAval(true);
				}
		    	obj60.setcFTextoAval(lrst.getString(P06BTablas.P06B_P06B32_ENTIDADAVAL)==null?"":lrst.getString(P06BTablas.P06B_P06B32_ENTIDADAVAL));

//			    obj60.setAprobado(0);

	        	//Mover datos originales
		    	P06B60T00Datatype datos60Originales = new P06B60T00Datatype();
		    	datos60Originales.setnExpediente(expediente.toUpperCase());
		    	datos60Originales.setcFDeclaro(lrst.getByte(P06BTablas.P06B_P06B60_CF_DECLARO));
		    	datos60Originales.setcFImpFondos(lrst.getString(P06BTablas.P06B_P06B60_CF_IMPFONDOS)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_IMPFONDOS));
		    	datos60Originales.setcFImpCapacidad(lrst.getString(P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD));
		    	datos60Originales.setcFContrataSeguro(lrst.getBoolean(P06BTablas.P06B_P06B60_CF_CONTRATASEGURO));
		    	datos60Originales.setcFTextoSeguro(lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOSEGURO)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOSEGURO));
		    	datos60Originales.setcFContrataAval(lrst.getBoolean(P06BTablas.P06B_P06B60_CF_CONTRATAAVAL));
		    	datos60Originales.setcFTextoAval(lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOAVAL)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOAVAL));

		    	obj60.setDatos60Originales(datos60Originales);
	        }
	        P06BLog.send(2,this, "Fin P06B60T00DAO-selectIncorporacion");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return obj60;
	}


	/**
    * Obtiene un registro de la BD a partir del c�digo
    * @param codigoPK.
    *            clave primaria
    * @return un objeto P06B60T00Datatype o null si no se encuentra
    * nada.
	 * @throws Exception
    */
	public P06B60T00Datatype selectIncorporacion(String expediente, int nEjerIncorporarDEC, P06B60T00Datatype capacidadFinanciera) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B60T00DAO-selectIncorporacion");
		P06B60T00Datatype obj60 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK_INCORPORACION2;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nEjerIncorporarDEC);
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	obj60 = new P06B60T00Datatype();

	        	//Mover campos 60
		    	obj60.setnExpediente(expediente.toUpperCase());
		    	byte declaracionDEC = lrst.getByte(P06BTablas.P06B_P06B32_TIPO_CAPAC_FINAN);
		    	byte declaracion = P06BConstantes.P06B_CF_NODEFINIDA;
		    	switch (declaracionDEC){
			    	case P06BConstantes.P06B_CFDEC_COBERTURAINMEDIATA:
			    		declaracion = P06BConstantes.P06B_CF_COBERTURAINMEDIATA;
			    		break;
			    	case P06BConstantes.P06B_CFDEC_CONTRATO:
			    		declaracion = P06BConstantes.P06B_CF_CONTRATO;
			    		break;
			    	case P06BConstantes.P06B_CFDEC_DEBECUMPLIMENTAR:
			    		declaracion = P06BConstantes.P06B_CF_DEBECUMPLIMENTAR;
			    		break;
			    	default:
			    		declaracion = P06BConstantes.P06B_CF_NODEFINIDA;
		    	}
		    	obj60.setcFDeclaro(declaracion);
		    	obj60.setcFImpFondos("");
		    	obj60.setcFImpCapacidad("");

		    	String sImportePoliza = lrst.getString(P06BTablas.P06B_P06B32_GARANTIAPOLIZA)==null?"":lrst.getString(P06BTablas.P06B_P06B32_GARANTIAPOLIZA);
		    	String sEntidadPoliza = lrst.getString(P06BTablas.P06B_P06B32_ENTIDADPOLIZA)==null?"":lrst.getString(P06BTablas.P06B_P06B32_ENTIDADPOLIZA);
		    	String sTextoPoliza = "";
		    	if (!"".equals(sEntidadPoliza.trim()) || !"".equals(sImportePoliza.trim())){
			    	obj60.setcFContrataSeguro(true);
		    		if (!"".equals(sEntidadPoliza.trim())){
				    	if (!"".equals(sTextoPoliza)){
					    	sTextoPoliza = sTextoPoliza + ": ";
				    	}
				    	sTextoPoliza = sEntidadPoliza.trim();
		    		}
		    		if (!"".equals(sImportePoliza.trim())){
				    	if (!"".equals(sTextoPoliza)){
					    	sTextoPoliza = sTextoPoliza + ": ";
				    	}
				    	sTextoPoliza = sTextoPoliza + sImportePoliza.trim();
		    		}
		    	}else{
			    	obj60.setcFContrataSeguro(true);
		    	}
		    	obj60.setcFTextoSeguro(sTextoPoliza);

		    	String sImporteAval = lrst.getString(P06BTablas.P06B_P06B32_IMPORTEAVAL)==null?"":lrst.getString(P06BTablas.P06B_P06B32_IMPORTEAVAL);
		    	String sEntidadAval = lrst.getString(P06BTablas.P06B_P06B32_ENTIDADAVAL)==null?"":lrst.getString(P06BTablas.P06B_P06B32_ENTIDADAVAL);
		    	String sTextoAval = "";
		    	if (!"".equals(sEntidadAval.trim()) || !"".equals(sImporteAval.trim())){
			    	obj60.setcFContrataAval(true);
		    		if (!"".equals(sEntidadAval.trim())){
				    	if (!"".equals(sTextoAval)){
					    	sTextoAval = sTextoAval + ": ";
				    	}
				    	sTextoAval = sEntidadAval.trim();
		    		}
		    		if (!"".equals(sImporteAval.trim())){
				    	if (!"".equals(sTextoAval)){
					    	sTextoAval = sTextoAval + ": ";
				    	}
				    	sTextoAval = sTextoAval + sImporteAval.trim();
		    		}
		    	}else{
			    	obj60.setcFContrataAval(true);
		    	}
		    	obj60.setcFTextoAval(sTextoAval);

	        }else{
	        	capacidadFinanciera.setOperacion(P06BConstantes.P06B_TO_CONSULTA);
	        	obj60 = new P06B60T00Datatype();
		    	obj60 = capacidadFinanciera;
	        }
	        P06BLog.send(2,this, "Fin P06B60T00DAO-selectIncorporacion");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	    	throw(e);
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return obj60;
	}


	/**
    * Obtiene un registro de la BD a partir del c�digo
    * @param codigoPK.
    *            clave primaria
    * @return un objeto P06B60T00Datatype o null si no se encuentra
    * nada.
	 * @throws Exception
    */
	public P06B60T00Datatype selectCapacidadFinancieraCorrelAtencionPeticionEnRevision(String expediente, int nCorrelAtencionPeticionEnRevision) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B60T00DAO-selectCapacidadFinancieraCorrelAtencionPeticionEnRevision");
		P06B60T00Datatype obj60 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK_CORRELATENCIONPETICIONENREVISION;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nCorrelAtencionPeticionEnRevision);
        	lrst = lstm.executeQuery();
	        while (lrst.next()) {
	        	obj60 = new P06B60T00Datatype();
		    	obj60.setnExpediente(expediente.toUpperCase());
//			    obj60.setAprobado(0);

	        	//Mover campos 80
		    	obj60.setcFDeclaro(lrst.getByte(P06BTablas.P06B_P06B80_CF_DECLARO));
		    	obj60.setcFImpFondos(lrst.getString(P06BTablas.P06B_P06B80_CF_IMPFONDOS)==null?"":lrst.getString(P06BTablas.P06B_P06B80_CF_IMPFONDOS));
		    	obj60.setcFImpCapacidad(lrst.getString(P06BTablas.P06B_P06B80_CF_IMPCAPACIDAD)==null?"":lrst.getString(P06BTablas.P06B_P06B80_CF_IMPCAPACIDAD));
		    	obj60.setcFContrataSeguro(lrst.getBoolean(P06BTablas.P06B_P06B80_CF_CONTRATASEGURO));
		    	obj60.setcFTextoSeguro(lrst.getString(P06BTablas.P06B_P06B80_CF_TEXTOSEGURO)==null?"":lrst.getString(P06BTablas.P06B_P06B80_CF_TEXTOSEGURO));
		    	obj60.setcFContrataAval(lrst.getBoolean(P06BTablas.P06B_P06B80_CF_CONTRATAAVAL));
		    	obj60.setcFTextoAval(lrst.getString(P06BTablas.P06B_P06B80_CF_TEXTOAVAL)==null?"":lrst.getString(P06BTablas.P06B_P06B80_CF_TEXTOAVAL));

	        	//Mover datos originales
		    	P06B60T00Datatype datos60Originales = new P06B60T00Datatype();
		    	datos60Originales.setnExpediente(expediente.toUpperCase());
		    	datos60Originales.setcFDeclaro(lrst.getByte(P06BTablas.P06B_P06B60_CF_DECLARO));
		    	datos60Originales.setcFImpFondos(lrst.getString(P06BTablas.P06B_P06B60_CF_IMPFONDOS)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_IMPFONDOS));
		    	datos60Originales.setcFImpCapacidad(lrst.getString(P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD));
		    	datos60Originales.setcFContrataSeguro(lrst.getBoolean(P06BTablas.P06B_P06B60_CF_CONTRATASEGURO));
		    	datos60Originales.setcFTextoSeguro(lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOSEGURO)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOSEGURO));
		    	datos60Originales.setcFContrataAval(lrst.getBoolean(P06BTablas.P06B_P06B60_CF_CONTRATAAVAL));
		    	datos60Originales.setcFTextoAval(lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOAVAL)==null?"":lrst.getString(P06BTablas.P06B_P06B60_CF_TEXTOAVAL));

		    	obj60.setDatos60Originales(datos60Originales);
	        }
	        P06BLog.send(2,this, "Fin P06B60T00DAO-selectCapacidadFinancieraCorrelAtencionPeticionEnRevision");
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return obj60;
	}


	/**
    * Obtiene un registro de la BD a partir del c�digo
    * @param codigoPK.
    *            clave primaria
    * @return un objeto P06B60T00Datatype o null si no se encuentra
    * nada.
	 * @throws Exception
    */
	public P06B60T00Datatype selectCapacidadFinancieraCorrelAtencionPeticionEnRevision2(String expediente, int nCorrelAtencionPeticionEnRevision, P06B60T00Datatype capacidadFinanciera) throws SQLException{
		P06BLog.send(2,this, "Inicio P06B60T00DAO-selectCapacidadFinancieraCorrelAtencionPeticionEnRevision");
		P06B60T00Datatype obj60 = null;
		PreparedStatement lstm  = null;
        ResultSet lrst  = null;
        String sql = SELECT_BY_PK_CORRELATENCIONPETICIONENREVISION;
        Connection lconConexion = P06BServidorConexionesBD.getConexionConsultas();
        try {
        	lstm = lconConexion.prepareStatement(sql);
        	lstm.setString(1,expediente.toUpperCase());
        	lstm.setInt(2,nCorrelAtencionPeticionEnRevision);
        	lrst = lstm.executeQuery();
	        if (lrst.next()) {
	        	obj60 = new P06B60T00Datatype();

	        	//Mover campos 80
				capacidadFinanciera.setOperacion(P06BConstantes.P06B_TO_MODIFICACION);
		    	obj60.setOperacion(P06BConstantes.P06B_TO_MODIFICACION);
		    	obj60.setnExpediente(expediente.toUpperCase());
		    	obj60.setcFDeclaro(lrst.getByte(P06BTablas.P06B_P06B80_CF_DECLARO));
		    	obj60.setcFImpFondos(lrst.getString(P06BTablas.P06B_P06B80_CF_IMPFONDOS)==null?"":lrst.getString(P06BTablas.P06B_P06B80_CF_IMPFONDOS));
		    	obj60.setcFImpCapacidad(lrst.getString(P06BTablas.P06B_P06B80_CF_IMPCAPACIDAD)==null?"":lrst.getString(P06BTablas.P06B_P06B80_CF_IMPCAPACIDAD));
		    	obj60.setcFContrataSeguro(lrst.getBoolean(P06BTablas.P06B_P06B80_CF_CONTRATASEGURO));
		    	obj60.setcFTextoSeguro(lrst.getString(P06BTablas.P06B_P06B80_CF_TEXTOSEGURO)==null?"":lrst.getString(P06BTablas.P06B_P06B80_CF_TEXTOSEGURO));
		    	obj60.setcFContrataAval(lrst.getBoolean(P06BTablas.P06B_P06B80_CF_CONTRATAAVAL));
		    	obj60.setcFTextoAval(lrst.getString(P06BTablas.P06B_P06B80_CF_TEXTOAVAL)==null?"":lrst.getString(P06BTablas.P06B_P06B80_CF_TEXTOAVAL));
	        }else{
	        	capacidadFinanciera.setOperacion(P06BConstantes.P06B_TO_CONSULTA);
	        	obj60 = new P06B60T00Datatype();
		    	obj60 = capacidadFinanciera;
	        }
	        P06BLog.send(2,this, "Fin P06B60T00DAO-selectCapacidadFinancieraCorrelAtencionPeticionEnRevision");
	    } catch (SQLException e) {
	    	P06BLog.send(2,this, "error: " +e.getMessage());
	    	throw(e);
	    }finally {
    		if(lrst!=null)
    			lrst.close();
        	if(lstm!=null)
        		lstm.close();
        	if(lconConexion!=null)
        		lconConexion.close();
	    }
		return obj60;
	}


	private static String INSERT_COMPLETA =
		"INSERT INTO "+ P06BTablas.P06B_P06B60T00_TABLA +
		" ("+
		P06BTablas.P06B_P06B60_CF_NUMEXP + "," +
		P06BTablas.P06B_P06B60_CF_DECLARO + "," +
		P06BTablas.P06B_P06B60_CF_IMPFONDOS + "," +
		P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD + "," +
		P06BTablas.P06B_P06B60_CF_CONTRATASEGURO + "," +
		P06BTablas.P06B_P06B60_CF_TEXTOSEGURO + "," +
		P06BTablas.P06B_P06B60_CF_CONTRATAAVAL + "," +
		P06BTablas.P06B_P06B60_CF_TEXTOAVAL +
		")"+
		" VALUES(?,?,?,?,?,?,?,?)";

	private static String UPDATE_COMPLETA =
		"UPDATE  "+ P06BTablas.P06B_P06B60T00_TABLA + " SET " +
		P06BTablas.P06B_P06B60_CF_DECLARO + "=?, " +
		P06BTablas.P06B_P06B60_CF_IMPFONDOS + "=?, " +
		P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD + "=?, " +
		P06BTablas.P06B_P06B60_CF_CONTRATASEGURO + "= ?, " +
		P06BTablas.P06B_P06B60_CF_TEXTOSEGURO + "=?, " +
		P06BTablas.P06B_P06B60_CF_CONTRATAAVAL + "= ?, " +
		P06BTablas.P06B_P06B60_CF_TEXTOAVAL + "=?" +
		" WHERE " + P06BTablas.P06B_P06B60_CF_NUMEXP + "=?";

	private static String DELETE_COMPLETA =
		"DELETE FROM "+ P06BTablas.P06B_P06B60T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B60_CF_NUMEXP + "=?";

	private static String SELECT_BY_PK_INCORPORACION =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B60_CF_DECLARO + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_IMPFONDOS + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_CONTRATASEGURO + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_TEXTOSEGURO + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_CONTRATAAVAL + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_TEXTOAVAL + ", "

		+ "S." + P06BTablas.P06B_P06B32_TIPO_CAPAC_FINAN + ", "
		+ "S." + P06BTablas.P06B_P06B32_ENTIDADAVAL + ", "
		+ "S." + P06BTablas.P06B_P06B32_IMPORTEAVAL
		+ " FROM " + P06BTablas.P06B_P06B60T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B32T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B32_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B32_EJERCICIO + "=?"
		+ " AND A." + P06BTablas.P06B_P06B60_CF_NUMEXP + "=S." + P06BTablas.P06B_P06B32_NUMEXP;

	private static String SELECT_BY_PK_INCORPORACION2 =
		" SELECT "
		+ P06BTablas.P06B_P06B32_TIPO_CAPAC_FINAN + ", "
		+ P06BTablas.P06B_P06B32_ENTIDADPOLIZA + ", "
		+ "TRIM(TO_CHAR(" + P06BTablas.P06B_P06B32_GARANTIAPOLIZA + ",'99G999G999G999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B32_GARANTIAPOLIZA + ", "
		+ P06BTablas.P06B_P06B32_ENTIDADAVAL + ", "
		+ "TRIM(TO_CHAR(" + P06BTablas.P06B_P06B32_IMPORTEAVAL + ",'99G999G999G999D99','NLS_NUMERIC_CHARACTERS = '',.')) AS " + P06BTablas.P06B_P06B32_IMPORTEAVAL
		+ " FROM " + P06BTablas.P06B_P06B32T00_TABLA
		+ " WHERE "
		+ P06BTablas.P06B_P06B32_NUMEXP + "=?"
		+ " AND " + P06BTablas.P06B_P06B32_EJERCICIO + "=?";

	private static String SELECT_BY_PK =
		"SELECT " +
		P06BTablas.P06B_P06B60_CF_NUMEXP + ", " +
		P06BTablas.P06B_P06B60_CF_DECLARO + ", " +
		P06BTablas.P06B_P06B60_CF_IMPFONDOS + ", " +
		P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD + ", " +
		P06BTablas.P06B_P06B60_CF_CONTRATASEGURO + ", " +
		P06BTablas.P06B_P06B60_CF_TEXTOSEGURO + ", " +
		P06BTablas.P06B_P06B60_CF_CONTRATAAVAL + ", " +
		P06BTablas.P06B_P06B60_CF_TEXTOAVAL +
		" FROM "+ P06BTablas.P06B_P06B60T00_TABLA +
		" WHERE " + P06BTablas.P06B_P06B60_CF_NUMEXP + " = ?";

	private static String SELECT_BY_PK_CORRELATENCIONPETICIONENREVISION =
		" SELECT "
		+ "2 AS operacion, "
		+ "A." + P06BTablas.P06B_P06B60_CF_DECLARO + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_IMPFONDOS + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_IMPCAPACIDAD + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_CONTRATASEGURO + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_TEXTOSEGURO + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_CONTRATAAVAL + ", "
		+ "A." + P06BTablas.P06B_P06B60_CF_TEXTOAVAL + ", "

		+ "S." + P06BTablas.P06B_P06B80_CF_DECLARO + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_IMPFONDOS + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_IMPCAPACIDAD + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_CONTRATASEGURO + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_TEXTOSEGURO + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_CONTRATAAVAL + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_TEXTOAVAL
		+ " FROM " + P06BTablas.P06B_P06B60T00_TABLA + " A,"
		+ P06BTablas.P06B_P06B80T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B80_CF_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B80_CF_CORRELATENCPETIC + "=?"
		+ " AND A." + P06BTablas.P06B_P06B60_CF_NUMEXP + "=S." + P06BTablas.P06B_P06B80_CF_NUMEXP;

	private static String SELECT_BY_PK_CORRELATENCIONPETICIONENREVISION2 =
		" SELECT "
		+ "S." + P06BTablas.P06B_P06B80_CF_DECLARO + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_IMPFONDOS + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_IMPCAPACIDAD + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_CONTRATASEGURO + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_TEXTOSEGURO + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_CONTRATAAVAL + ", "
		+ "S." + P06BTablas.P06B_P06B80_CF_TEXTOAVAL
		+ " FROM " + P06BTablas.P06B_P06B80T00_TABLA + " S"
		+ " WHERE "
		+ "S." + P06BTablas.P06B_P06B80_CF_NUMEXP + "=?"
		+ " AND S." + P06BTablas.P06B_P06B80_CF_CORRELATENCPETIC + "=?";
}
